/*
 * Decompiled with CFR 0.152.
 */
package com.zkryle.jeg.common.golem;

import com.zkryle.jeg.common.customgoals.TamedNearestAttackGoal;
import com.zkryle.jeg.common.golem.EnragedMagmaticGolemEntity;
import com.zkryle.jeg.core.Init;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class MagmaticGolemEntity
extends TameableEntity {
    public float headInclination;
    private boolean isOn = true;
    private ArrayList<Goal> registeredGoals;
    public boolean isTransforming = false;

    public MagmaticGolemEntity(EntityType<? extends MagmaticGolemEntity> entityType, World level) {
        super(entityType, level);
    }

    private MagmaticGolemEntity(World level) {
        this((EntityType<? extends MagmaticGolemEntity>)((EntityType)Init.MAGMATIC_GOLEM_ENTITY.get()), level);
    }

    public static MagmaticGolemEntity createMagmaticGolemEntity(World level) {
        return new MagmaticGolemEntity(level);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233823_f_, 1.5).func_233815_a_(Attributes.field_233820_c_, 1.0);
    }

    public ILivingEntityData func_213386_a(IServerWorld p_146746_, DifficultyInstance p_146747_, SpawnReason p_146748_, @Nullable ILivingEntityData p_146749_, @Nullable CompoundNBT p_146750_) {
        if (!p_146748_.equals((Object)SpawnReason.CHUNK_GENERATION)) {
            this.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_151006_E));
        }
        return super.func_213386_a(p_146746_, p_146747_, p_146748_, p_146749_, p_146750_);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.addToRegisteredGoals(new Goal[]{new MeleeAttackGoal((CreatureEntity)this, 0.45, false), new FollowOwnerGoal((TameableEntity)this, 0.45, 7.5f, 2.0f, false), new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.3), new LookAtGoal((MobEntity)this, LivingEntity.class, 5.0f), new LookRandomlyGoal((MobEntity)this)});
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PiglinEntity.class, false));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractSkeletonEntity.class, false));
        this.field_70715_bh.func_75776_a(6, new TamedNearestAttackGoal(this, PlayerEntity.class, false));
    }

    private void addToRegisteredGoals(Goal ... goals) {
        ArrayList<Goal> goalsArray = new ArrayList<Goal>(Arrays.stream(goals).toArray().length);
        goalsArray.addAll(Arrays.asList(goals));
        this.registeredGoals = goalsArray;
        int i = 1;
        for (Goal goal : this.registeredGoals) {
            this.field_70714_bg.func_75776_a(i, goal);
            ++i;
        }
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return null;
    }

    @Deprecated
    public void setTamed(PlayerEntity pPlayer) {
        this.func_193101_c(pPlayer);
        this.field_70699_by.func_75499_g();
        this.func_70624_b(null);
        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
        this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
    }

    public ActionResultType func_230254_b_(PlayerEntity pPlayer, Hand pHand) {
        if (pPlayer.func_184586_b(pHand).func_77973_b() == Items.field_151072_bj && pPlayer.func_110124_au().equals(this.func_184753_b())) {
            if (this.isOn()) {
                this.func_184185_a((SoundEvent)Init.MAGMATIC_GOLEM_SHUTDOWN.get(), 1.0f, 1.0f);
            } else {
                this.func_184185_a((SoundEvent)Init.MAGMATIC_GOLEM_STARTING.get(), 1.0f, 1.0f);
            }
            this.setOn(!this.isOn());
            return ActionResultType.SUCCESS;
        }
        if ((pPlayer.func_184586_b(pHand).func_77973_b() instanceof SwordItem || pPlayer.func_184586_b(pHand).func_77973_b() instanceof AxeItem) && this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b() && pPlayer.func_110124_au().equals(this.func_184753_b())) {
            pPlayer.field_70170_p.func_184133_a(pPlayer, this.func_233580_cy_(), SoundEvents.field_187719_p, SoundCategory.AMBIENT, 1.0f, 1.0f);
            this.func_184201_a(EquipmentSlotType.MAINHAND, pPlayer.func_184586_b(pHand).func_77946_l());
            pPlayer.func_184586_b(pHand).func_190918_g(1);
            return ActionResultType.SUCCESS;
        }
        if (pPlayer.func_184586_b(pHand).func_190926_b() && pPlayer.func_110124_au().equals(this.func_184753_b()) && !this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b()) {
            pPlayer.func_184611_a(pHand, this.func_184582_a(EquipmentSlotType.MAINHAND).func_77946_l());
            this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
            return ActionResultType.SUCCESS;
        }
        if (pPlayer.func_184586_b(pHand).func_77973_b() == Init.MAGMATIC_OBSIDIAN_ITEM.get() && this.func_110143_aJ() < this.func_110138_aP()) {
            if (!pPlayer.field_71075_bZ.field_75098_d) {
                pPlayer.func_184586_b(pHand).func_190918_g(1);
            }
            this.func_184185_a(SoundEvents.field_226143_fP_, 1.0f, 1.0f);
            this.func_70691_i(8.0f);
            return ActionResultType.SUCCESS;
        }
        if (pPlayer.func_184586_b(pHand).func_77973_b() == Init.MAGMATIC_PENDANT_ITEM.get()) {
            if (!pPlayer.field_71075_bZ.field_75098_d) {
                pPlayer.func_184586_b(pHand).func_190918_g(1);
            }
            return this.executeTransformation(pPlayer);
        }
        return ActionResultType.PASS;
    }

    public boolean isOn() {
        return this.isOn;
    }

    public void setOn(boolean on) {
        if (!this.field_70170_p.func_201670_d()) {
            if (on) {
                for (int i = 0; i < this.registeredGoals.size(); ++i) {
                    this.field_70714_bg.func_75776_a(i, this.registeredGoals.get(i));
                }
            } else {
                this.registeredGoals.forEach(arg_0 -> ((GoalSelector)this.field_70714_bg).func_85156_a(arg_0));
            }
        }
        if (on) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)5);
        } else {
            this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        }
        this.isOn = on;
    }

    public void func_70103_a(byte pId) {
        if (pId == 4) {
            this.isOn = false;
        } else if (pId == 5) {
            this.isOn = true;
        } else if (pId == 7) {
            this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
            super.func_70103_a(pId);
        }
        super.func_70103_a(pId);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.isOn()) {
            if (this.headInclination > -0.5f) {
                this.headInclination -= 0.05f;
            }
        } else if (this.headInclination < 0.0f) {
            this.headInclination += 0.05f;
        }
    }

    protected void func_213337_cE() {
        if (this.func_70909_n()) {
            this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_213303_ch().func_82615_a(), this.func_213303_ch().func_82617_b(), this.func_213303_ch().func_82616_c(), this.func_184582_a(EquipmentSlotType.MAINHAND).func_77946_l()));
            this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
        }
    }

    public boolean func_230279_az_() {
        return true;
    }

    public boolean func_213380_a(IWorld pLevel, SpawnReason pSpawnReason) {
        BlockState blockBelow = pLevel.func_180495_p(this.func_233580_cy_().func_177977_b());
        return blockBelow.func_215688_a((IBlockReader)pLevel, this.func_233580_cy_().func_177977_b(), (EntityType)Init.MAGMATIC_GOLEM_ENTITY.get()) && blockBelow.func_177230_c() != Blocks.field_189878_dg;
    }

    public void func_70636_d() {
        this.func_82168_bl();
        super.func_70636_d();
    }

    public boolean func_205019_a(IWorldReader pLevel) {
        return pLevel.func_226668_i_((Entity)this) && !pLevel.func_72953_d(this.func_174813_aQ());
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource pDamageSource) {
        return (SoundEvent)Init.MAGMATIC_GOLEM_HURTS.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)Init.MAGMATIC_GOLEM_DIES.get();
    }

    public boolean func_70652_k(Entity pEntity) {
        boolean fireFlag;
        if (this.func_70909_n()) {
            this.func_184614_ca().func_222118_a(1, (LivingEntity)this, p_213833_1_ -> p_213833_1_.func_213334_d(Hand.MAIN_HAND));
        }
        boolean bl = fireFlag = new Random().nextInt(100) < 10;
        if (fireFlag) {
            pEntity.func_70015_d(10);
        }
        pEntity.field_70170_p.func_184133_a(null, pEntity.func_233580_cy_(), SoundEvents.field_187727_dV, SoundCategory.HOSTILE, 1.0f, 1.0f);
        return super.func_70652_k(pEntity);
    }

    public ActionResultType executeTransformation(PlayerEntity pPlayer) {
        if (this.func_184753_b() != null && this.func_184753_b().equals(pPlayer.func_110124_au())) {
            this.isTransforming = true;
            this.func_70106_y();
            this.func_184185_a((SoundEvent)Init.MAGMATIC_GOLEM_TRANSFORMS.get(), 1.0f, 1.0f);
            if (!this.field_70170_p.func_201670_d()) {
                this.field_70170_p.func_217398_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 3.0f, true, Explosion.Mode.DESTROY);
            }
            this.drawExplosionSphere();
            EnragedMagmaticGolemEntity enragedGolem = new EnragedMagmaticGolemEntity((EntityType<? extends TameableEntity>)((EntityType)Init.ENRAGED_MAGMATIC_GOLEM_ENTITY.get()), this.field_70170_p);
            enragedGolem.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            this.field_70170_p.func_217376_c((Entity)enragedGolem);
            this.func_213337_cE();
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    private void drawExplosionSphere() {
        if (!this.field_70170_p.func_201670_d()) {
            Vector3d pos = this.func_213303_ch();
            int radius = 3;
            int r2 = radius * radius;
            for (int X = -radius; X <= radius; ++X) {
                int x2 = X * X;
                for (int Y = -radius; Y <= radius; ++Y) {
                    int y2 = Y * Y;
                    for (int Z = -radius; Z <= radius; ++Z) {
                        if (x2 + y2 + Z * Z > r2) continue;
                        ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197627_t, pos.func_82615_a() + 0.5 + (double)X, pos.func_82617_b() + 0.5 + (double)Y, pos.func_82616_c() + 0.5 + (double)Z, 2, 0.0, 0.0, 0.0, 1.0);
                    }
                }
            }
        }
    }

    public void func_70623_bb() {
        if (!this.func_70909_n()) {
            super.func_70623_bb();
        }
    }
}

